/** @file   flamertalien.h
 * @brief   Declaration of FlamerAlien - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_FLAMERALIEN_H
#define H_WWW_FLAMERALIEN_H

#include "minigunalien.h"

namespace WeWantWar {

/** @class  FlamerAlien
 * @brief   An alien with flamethrower.
 * @author  Tomi Lamminsaari
 *
 */
class FlamerAlien : public Alien
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  /** Index of the controlpoint we use for the weapon nose. */
  static const int GUN_CONTROLPOINT_INDEX = 0;

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	FlamerAlien();


	/** Destructor
   */
	virtual ~FlamerAlien();

private:

	/** Copy constructor.
   * @param     rO                Reference to another FlamerAlien
   */
  FlamerAlien( const FlamerAlien& rO );

	/** Assignment operator
   * @param     rO                Reference to another FlamerAlien
   * @return    Reference to us.
   */
  FlamerAlien& operator = ( const FlamerAlien& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this alien
   */
  virtual void update();
  
  
  /** Makes sound
   * @param     aSoundId          Id-code of the sound we should produce
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** Handles the bullet hits
   * @param     aBullet           Pointer to bullet that hit us.
   * @return    true if we died.
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** Reimplemented because we want to inform out controller when we got hurt.
   * @param     aBullet           Pointer to bullet that hurt us.
   * @return    true if we died
   */
//  virtual bool causeDamage( Bullet* aBullet );
  
  /** Kills this object
   */
  virtual void kill();
  

  ///
  /// Getter methods
  /// ==============

  /** Returns the type of this object.
   * @return    ObjectID::TYPE_FLAMERALIEN
   */
  virtual ObjectID::Type objectType() const;
  
  

protected:

  /** Sets the requested animation,
   * @param     aAnimId           Id of the animation we should set up
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Shoots
   */
  virtual void attack();
  
  
  
  ///
  /// Members
  /// =======

  /** The walking speed. */
  eng2d::Vec2D iWalkVec;
  


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: flameralien.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:57+02  lamminsa
 * Initial revision
 *
 */

